import logging
import requests


class SlackNotifier:
    def __init__(self, base_url, component_name, task_id, revision):
        self.session = requests.session()
        self.base_url = base_url
        self.task_id = task_id
        self.revision = revision
        self.component_name = component_name

    def _send_notification_info(self, type, data):
        try:
            url = f'{self.base_url}/{type}'
            logging.info(f'Sending notification info to {url}. data: {data}')
            resp = requests.post(url, json=data, timeout=10)
            if not resp.ok:
                logging.error(f'Failed to send notification info. status_code: {resp.status_code}, response: {resp.content}')
        except Exception:
            logging.error("Failed to send notification", exc_info=True)

    def register_build(self, commit_message, commiter):
        data = {
            'commit_message': commit_message,
            'committer': commiter,
            'revision': self.revision,
        }
        self._send_notification_info('register-build', data)

    def report_status(self, status):
        data = {
            'revision': self.revision,
            'component_name': self.component_name,
            'status': status,
            'task_id': self.task_id,
        }
        self._send_notification_info('report-status', data)
