import os

MAX_CONTENT_LENGTH = 16 * 1024 * 1024  # 16MB
PG_SCHEMA_RESOURCE_NAME = '/pg_schema'
SLACK_API_KEY = os.getenv("SLACK_API_KEY", "")
NANNY_TOKEN = os.getenv("NANNY_TOKEN", "")
ABC_TOKEN = os.getenv("ABC_TOKEN", "")
WIKI_TOKEN = os.getenv("WIKI_TOKEN", "")
ARC_TOKEN = os.getenv("ARC_TOKEN", "")
SANDBOX_TOKEN = os.getenv("SANDBOX_TOKEN", "")
ST_TOKEN = os.getenv("ST_TOKEN", "")
STAFF_TOKEN = os.getenv("STAFF_TOKEN", "")
TVM_SECRET = os.getenv("TVM_SECRET", "tvm-secret")
SLACK_CHANNELS = {
    "travel-build": "C7GNHMHJ9",
    "devops": "C1KL4016K",
    'experimental2': 'C012007RR6H',
    "mpivko-experimental": "GLX6P3L20",
    "travel-release": "C012X5LSER2",
}
COMPONENTS_POSTED_TO_DEVOPS = [
    'searcher',
    'offercache',
    'pricechecker',
    'redir',
    'boiler',
    'api',
    'orders',
    'geocounter',
    'hotels-administrator',
    'external-api',
    'teller-app',
    'busbroker',
    'cpa-flow',
    'tugc',
    'promogranter',
]
COMPONENTS_WITHOUT_LOST_COMMITS_REPORT = [
    'partner-mocks',  # Used only in testing
    'teller-app',  # Not used yet
    'distributor',  # Removed forever, remains here so we wont receive notifications about it
    'budapest-activator',
    'budapest-crm-importer',
    'budapest-importer-v2',
    'budapest-meta-pms-activator',
    'budapest-meta-pms-notifier',
    'budapest-meta-pms-synchronizer',
    'budapest-meta-pms-telegram-bot',
    'budapest-metapms-status-trigger',
    'budapest-rooms-backend',
    'budapest-rooms-migration-db',
    'budapest-promo-tool-v2',
]
NANNY_COMPONENTS = {
    'searcher': ['travel_hotels_searcher_prod'],
    'offercache': ['travel_hotels_offercache_prod'],
    'pricechecker': ['travel_hotels_pc_prod'],
    'redir': ['travel_hotels_redir_prod'],
    'boiler': ['travel_hotels_boiler_prod'],
    'api': ['travel_hotels_api_prod'],
    'orders': ['travel_orders_app_prod'],
    'geocounter': ['travel_hotels_geocounter_prod'],
    'hotels-administrator': ['travel_hotels_administrator_prod'],
    'external-api': ['travel_external_api_prod'],
    'busbroker': ['travel_hotels_busbroker_prod'],
    'promogranter': ['travel_promogranter_prod'],
    'teller-app': [],
    'BoY hotel checker tg-bot': [],
    'slack-forwarder': [],
    'cpa-flow': [],
}
NO_OVERRIDE_CHECK_SERVICES = [
    'travel_orders_app_stress',
    'travel_hotels_api_stress',
]
HOLIDAYS = [
    ["2021-05-01", "2021-05-10"],
    ["2021-12-31", "2022-01-09"],
    ["2022-04-30", "2022-05-03"],
    ["2022-05-07", "2022-05-10"],
]
HOST = '::'
PORT = 9098
SELF_TVM_ID=2025960
SANDBOX_TVM_ID='2002826'
CHANGELOGS_WIKI_PATH = 'travel/hotels/dev/changelogs'

PG_DB_NAME = 'travel-ci-db'
PG_DB_USER = 'user'
PG_DB_PASSWORD = os.getenv("POSTGRESQL_PASSWORD", "")
PG_DB_HOST = 'man-p5n7zoygxb2wqbjf.db.yandex.net,sas-w5de1f4upipjuxbr.db.yandex.net,vla-t5jqg1zm6gn39gag.db.yandex.net'
PG_DB_PORT = 6432

DB_LOCK_PING_INTERVAL_SEC = 3

LOG_FILENAME = '/logs/slack-forwarder.log'
