import gevent
import time

from travel.hotels.devops.slack_forwarder.app import app
from travel.hotels.devops.slack_forwarder.pg_db import _get_cursor


def get_pg_lock_and_wait(lock_id, on_start_func, on_lock_lost_func):
    with _get_cursor() as cursor:
        while True:
            app.logger.info(f'Trying to acquire lock {lock_id}')
            cursor.execute('SELECT pg_try_advisory_lock(%s)', [lock_id])
            if list(cursor)[0][0]:
                break
            app.logger.info(f'Can\'t acquire lock {lock_id}, it\'s acquired by somebody else')
            time.sleep(app.config['DB_LOCK_PING_INTERVAL_SEC'])
        app.logger.info(f'Successfully acquired lock {lock_id}')
        gevent.spawn(on_start_func)
        try:
            while True:
                cursor.execute('SELECT 1')
                if list(cursor)[0][0] != 1:
                    break
                app.logger.debug(f'Ping transaction with lock {lock_id} is successful')
                time.sleep(app.config['DB_LOCK_PING_INTERVAL_SEC'])
        except Exception as e:
            app.logger.warn(f'Failed to ping transaction with lock {lock_id}', e)
        finally:
            app.logger.info(f'Can\'t ping transaction with lock {lock_id}, stopping lock')
            on_lock_lost_func()
