class DutyConfig:
    def __init__(self, service_id, name, tag_prefix, name_nominative_case, name_genitive_case, allow_future_shifts, post_to_devops, schedule_ids=None, duty_tickets_queue=None):
        self.service_id = service_id
        self.name = name
        self.allow_future_shifts = allow_future_shifts
        self.post_to_devops = post_to_devops
        self.duty_required_tag = f'{tag_prefix}_duty_required'
        self.duty_summoneed_tag = f'{tag_prefix}_duty_summoned'
        self.name_nominative_case = name_nominative_case
        self.name_genitive_case = name_genitive_case
        self.schedule_ids = schedule_ids
        self.duty_tickets_queue = duty_tickets_queue


class DutyRegistry:
    def __init__(self):
        self._services = [
            DutyConfig(748, "Отели", 'hotel', 'разработчик', 'разработчика', allow_future_shifts=False, post_to_devops=True, schedule_ids=[2500], duty_tickets_queue='HOTELDUTY'),
            DutyConfig(2499, "Авиа", 'avia', 'разработчик', 'разработчика', allow_future_shifts=False, post_to_devops=True),
            DutyConfig(1414, "ЖД+Автобусы", 'buses', 'разработчик', 'разработчика', allow_future_shifts=False, post_to_devops=True),
            DutyConfig(1236, "Электрички", 'rasp', 'разработчик', 'разработчика', allow_future_shifts=False, post_to_devops=True),
            DutyConfig(2833, "Оркестратор", 'orders', 'разработчик', 'разработчика', allow_future_shifts=False, post_to_devops=True),
            DutyConfig(37650, "Биздев", 'bizdev', 'биздев', 'биздева', allow_future_shifts=True, post_to_devops=False, schedule_ids=[4897]),
            DutyConfig(38648, "Саппорт", 'support', 'саппорт', 'саппорта', allow_future_shifts=False, post_to_devops=False, schedule_ids=[5233]),
        ]

    def get_duties_for_devops(self):
        return [x for x in self._services if x.post_to_devops]

    def get_duties_for_st_duty(self):
        return self._services
