from typing import List, Dict


class CommitInfo:
    def __init__(self, revision: int, timestamp: int, author: str):
        self.revision = revision
        self.timestamp = timestamp
        self.author = author


class LostCommitsInfo:
    def __init__(self, component_name: str, last_release_timestamp: int, commits: List[CommitInfo]):
        self.component_name = component_name
        self.last_release_timestamp = last_release_timestamp
        self.commits = commits


class LostCommitsInfoByAuthor:
    def __init__(self, component_name: str, commits: List[CommitInfo]):
        self.component_name = component_name
        self.commits = commits


class LostCommitsReport:
    def __init__(self, by_components: List[LostCommitsInfo], by_authors: Dict[str, List[LostCommitsInfoByAuthor]]):
        self.by_components = by_components
        self.by_authors = by_authors
