from travel.hotels.devops.slack_forwarder.notifier import Notifier

notifier_worker = None


def run():
    global notifier_worker
    notifier_worker = Notifier()
    notifier_worker.run_sender()


def trigger_notification(revision):
    notifier_worker.enqueue_notification(revision)


def send_plaintext_notification(text, channel_name):
    notifier_worker.send_plaintext_notification(text, channel_name)


def send_release_report(component_name, revision, task_id, releaser, revisions):
    notifier_worker.send_release_report(component_name, revision, task_id, releaser, revisions)


def send_nanny_update_report(service_id, current_snapshot_id, prev_snapshot_id, releaser):
    notifier_worker.send_nanny_update_report(service_id, current_snapshot_id, prev_snapshot_id, releaser)


def send_pause_report(service_id, is_paused, comment, author):
    notifier_worker.send_pause_report(service_id, is_paused, comment, author)
