import time

from travel.hotels.devops.slack_forwarder.abc_service import AbcService
from travel.hotels.devops.slack_forwarder.app import app
from travel.hotels.devops.slack_forwarder.duty_registry import DutyRegistry
from travel.hotels.devops.slack_forwarder.utils import should_run_regular_check
from travel.hotels.devops.slack_forwarder.notifier_worker import send_plaintext_notification


class DutyConfig:
    def __init__(self, id, name, allow_future_shifts):
        self.id = id
        self.name = name
        self.allow_future_shifts = allow_future_shifts


class OnDuty:
    def __init__(self, token):
        self._abc_service = AbcService(token)
        self._last_check_time = 0
        self.registry = DutyRegistry()

    def run(self):
        with app.app_context():
            while True:
                try:
                    self._check()
                except Exception:
                    app.logger.error('Exception while watching onduty', exc_info=True)
                time.sleep(60)

    def _check(self, force=False):
        # Run check only in interval 12-13 MSK (14-15 EKB) on weekdays, and not not more often than each 2 hours
        if not force and not should_run_regular_check(self._last_check_time, from_utc_hour=9, to_utc_hour=10):
            return

        app.logger.info("Checking onduty")

        for duty_config in self.registry.get_duties_for_devops():
            duty_roles = self._abc_service.get_duty_roles(duty_config)
            for duty_role in duty_roles:
                notification_text = f'Дежурство в cервисе "{duty_config.name}": '
                if len(duty_roles) > 1:
                    notification_text += f'{duty_role.role_name}: '
                if duty_role.user_login is not None and duty_role.user_name is not None:
                    notification_text += f'<https://staff.yandex-team.ru/{duty_role.user_login}|{duty_role.user_name}> (@{duty_role.user_login})'
                else:
                    notification_text += '**Дежурный не назначен**'
                send_plaintext_notification(notification_text, 'devops')

        self._last_check_time = time.time()
