import psycopg2
import psycopg2.pool
from flask import g
from library.python import resource
from contextlib import contextmanager

from travel.hotels.devops.slack_forwarder.app import app


def get_pool():
    pool = getattr(g, '_pg_pool', None)
    if pool is None:
        pool = g._pg_pool = psycopg2.pool.SimpleConnectionPool(minconn=1, maxconn=10, dbname=app.config['PG_DB_NAME'], user=app.config['PG_DB_USER'],
                                                               password=app.config['PG_DB_PASSWORD'], host=app.config['PG_DB_HOST'], port=app.config['PG_DB_PORT'],
                                                               target_session_attrs='read-write')
    return pool


def pg_query_db(query, args=()):
    with _get_cursor() as cursor:
        cursor.execute(query, args)
        return list(cursor)


def pg_query_db_and_commit(query, args=()):
    with _get_cursor() as cursor:
        cursor.execute(query, args)


@contextmanager
def _get_cursor():
    conn = get_pool().getconn()
    try:
        try:
            cursor = conn.cursor()
        except psycopg2.Error as e:
            app.logger.warn('Error while creating cursor, trying other connection', exc_info=e)
            get_pool().putconn(conn, close=True)
            conn = get_pool().getconn()
            cursor = conn.cursor()
        with conn:
            with cursor:
                yield cursor
    finally:
        get_pool().putconn(conn)


def pg_init_db():
    pg_query_db_and_commit(resource.find(app.config['PG_SCHEMA_RESOURCE_NAME']))


@app.teardown_appcontext
def close_connection(exception):
    pool = getattr(g, '_pg_pool', None)
    if pool is not None:
        pool.closeall()
