CREATE TABLE IF NOT EXISTS events (
    id bigserial PRIMARY KEY,
    "timestamp" timestamp DEFAULT current_timestamp,
    revision text NOT NULL,
    component text NOT NULL,
    event_type text NOT NULL,
    task_id text NOT NULL,
    processed integer DEFAULT 0
);
CREATE TABLE IF NOT EXISTS builds (
    revision text NOT NULL PRIMARY KEY,
    "timestamp" timestamp DEFAULT current_timestamp,
    committer text NOT NULL,
    commit_message text NOT NULL,
    ts text
);
CREATE TABLE IF NOT EXISTS deployments (
    task_id text NOT NULL,
    env text NOT NULL,
    status text NOT NULL,
    start_time integer,
    end_time integer,
    "timestamp" timestamp DEFAULT current_timestamp,

    PRIMARY KEY (task_id, env)
);
CREATE TABLE IF NOT EXISTS releases (
    id bigserial PRIMARY KEY,
    "timestamp" timestamp DEFAULT current_timestamp,
    revision text NOT NULL,
    component_name text NOT NULL,
    revisions text NOT NULL,
    task_id text NOT NULL,
    releaser text NOT NULL,
    env text NOT NULL
);
CREATE TABLE IF NOT EXISTS nanny_releases (
    service_id text NOT NULL,
    "timestamp" timestamp DEFAULT current_timestamp,
    last_snapshot_id text NOT NULL,

    PRIMARY KEY (service_id)
);
CREATE TABLE IF NOT EXISTS nanny_service_statuses (
    service_id text NOT NULL,
    status text NOT NULL,
    "timestamp" timestamp DEFAULT current_timestamp,

    PRIMARY KEY (service_id)
);
