from gevent.lock import Semaphore

from sandbox.common import rest
from sandbox.common import auth
from flask import g

from travel.hotels.devops.slack_forwarder.app import app


class ReleaseBadRequestException(Exception):
    def __init__(self, error_text):
        self.error_text = error_text


class ReleaseFailedException(Exception):
    def __init__(self, error_text):
        self.error_text = error_text


class SbClient:
    def __init__(self, token):
        self._lock = Semaphore(value=1)

    def release_task_to_stable(self, task_id, service_ticket):
        client = rest.Client(auth=auth.TVMSession(service_ticket, g.user['user_ticket']))
        releaser = g.user['login']

        with self._lock:
            app.logger.info(f'Release triggered for task: {task_id}')
            try:
                client.release({
                    'task_id': task_id,
                    'subject': f'Travel release by @{releaser}',
                    'type': 'stable',
                })
            except rest.Client.HTTPError as e:
                if e.status == 400:
                    raise ReleaseBadRequestException(f'Got bad request error from sandbox: {SbClient._get_bad_request_reason(e)}')
                elif 500 <= e.status <= 599:
                    raise ReleaseFailedException(f'Got 5xx error from sandbox: {e.response}')
                else:
                    raise e

    @staticmethod
    def _get_bad_request_reason(e):
        try:
            return e.response.json()['reason']
        except Exception:
            return e.response.text
