$(document).ready(function () {
    $('.pause-button').click(function () {
        const action = $(this).attr('data-action');
        const service_id = $(this).attr('data-service-id');
        const unique_id = $(this).attr('data-unique-id');
        var confirm_button = $(`#confirm-pause-button-${unique_id}`);
        confirm_button.attr('data-action', action);
        confirm_button.attr('data-service-id', service_id);
        confirm_button.attr('data-unique-id', unique_id);

        var msgPause = $(`#pauseModalPause-${unique_id}`);
        var msgResume = $(`#pauseModalResume-${unique_id}`);
        if (action === 'pause') {
            msgPause.show();
            msgResume.hide();
        } else {
            msgPause.hide();
            msgResume.show();
        }

        $(`#pauseModal-${unique_id}`).modal();
    });
    $('.confirm-pause-button').click(function () {
        const action = $(this).attr('data-action');
        const service_id = $(this).attr('data-service-id');
        const unique_id = $(this).attr('data-unique-id');
        const comment = $(`#pause-comment-${unique_id}`).val();
        $.ajax({
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({service_id: service_id, action: action, comment: comment}),
            dataType: 'json',
            url: '/api/pause',
            success: function (e) {
                var nanny = $(`#pauseDoneModalNanny-${unique_id}`);
                if (e['nanny_service_id'] === undefined) {
                    nanny.hide();
                } else {
                    nanny.show();
                    var nanny_link = $(`#pauseDoneModalNannyLink-${unique_id}`);
                    nanny_link.text(`nanny`);
                    nanny_link.attr('href', `https://nanny.yandex-team.ru/ui/#/services/catalog/${e['nanny_service_id']}/`);
                }

                var msgPaused = $(`#pauseDoneModalMsgPaused-${unique_id}`);
                var msgResumed = $(`#pauseDoneModalMsgResumed-${unique_id}`);
                if (e['result'] === 'paused') {
                    msgPaused.show();
                    msgResumed.hide();
                } else {
                    msgPaused.hide();
                    msgResumed.show();
                }

                $(`#pauseModal-${unique_id}`).modal('hide');
                $(`#pauseDoneModal-${unique_id}`).modal();
            },
            error: function (error) {
                console.log(error);
                $(`#pauseFailedModalErrorHolder-${unique_id}`).text(error.responseText);
                $(`#pauseModal-${unique_id}`).modal('hide');
                $(`#pauseFailedModal-${unique_id}`).modal();
            }
        });
    });
    $('.trigger-release-button').click(function () {
        const task_id = $(this).attr('data-task-id');
        const revision = $(this).attr('data-revision');
        const unique_id = $(this).attr('data-unique-id');
        var confirm_button = $(`#confirm-release-button-${unique_id}`);
        confirm_button.attr('data-task-id', task_id);
        confirm_button.attr('data-unique-id', unique_id);
        $(`.trigger-release-modal-commit-${unique_id}`).each((k, v) => {
            if (parseInt($(v).attr('data-revision')) > revision) {
                $(v).hide();
            } else {
                $(v).show();
            }
        });

        $(`#triggerReleaseModal-${unique_id}`).modal();
    });
    $('.confirm-release-button').click(function () {
        const task_id = $(this).attr('data-task-id');
        const unique_id = $(this).attr('data-unique-id');
        $.ajax({
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({task_id: task_id}),
            dataType: 'json',
            url: '/api/release',
            success: function (e) {
                var revision = $(`#releaseDoneModalRevisionLink-${unique_id}`);
                revision.text(`r${e['revision']}`);
                revision.attr('href', `https://a.yandex-team.ru/arc/commit/${e['revision']}`);

                var sandbox = $(`#releaseDoneModalSandboxLink-${unique_id}`);
                sandbox.text(`${e['task_id']}`);
                sandbox.attr('href', `https://sandbox.yandex-team.ru/task/${e['task_id']}`);

                var nanny = $(`#releaseDoneModalNanny-${unique_id}`);
                if (e['nanny_link'] === undefined) {
                    nanny.hide();
                } else {
                    nanny.show();
                    var nanny_link = $(`#releaseDoneModalNannyLink-${unique_id}`);
                    nanny_link.text(`nanny`);
                    nanny_link.attr('href', e['nanny_link']);
                }

                $(`#triggerReleaseModal-${unique_id}`).modal('hide');
                $(`#releaseDoneModal-${unique_id}`).modal();
            },
            error: function (error) {
                console.log(error);
                $(`#releaseFailedModalErrorHolder-${unique_id}`).text(error.responseText);
                $(`#triggerReleaseModal-${unique_id}`).modal('hide');
                $(`#releaseFailedModal-${unique_id}`).modal();
            }
        });
    });
});
