import datetime
import time
import re

from travel.hotels.devops.slack_forwarder.app import app


def get_days_form(days):
    if days == 1:
        return "день"
    if (days < 10 or days > 20) and days % 10 in [2, 3, 4]:
        return "дня"
    return "дней"


def normalize_component_name(component_name):
    return re.sub(r'\W', '-', component_name).lower()


def _get_holidays():
    res = []
    for date_from, date_to in app.config['HOLIDAYS']:
        res.append([
            datetime.datetime.fromisoformat(date_from),  # start of date_from day
            datetime.datetime.fromisoformat(date_to) + datetime.timedelta(1),  # start of the next day ~ end of date_to day
        ])
    return res


def should_run_regular_check(last_run_time, from_utc_hour: int, to_utc_hour: int):
    now = datetime.datetime.utcnow()
    is_weekend = now.weekday() >= 5
    is_holiday = any([f <= now <= t for f, t in _get_holidays()])
    return from_utc_hour <= now.hour < to_utc_hour and time.time() - last_run_time > 2 * 60 * 60 and not is_weekend and not is_holiday
