import requests


class WikiApi:
    def __init__(self, token):
        self.base_url = 'https://wiki-api.yandex-team.ru/_api/frontend'
        self.token = token

    def post_page(self, path: str, title: str, body: str):
        url = f'{self.base_url}/{path}'
        resp = requests.post(url, json={
            'title': title,
            'body': body
        }, headers={
            'Authorization': f'OAuth {self.token}',
        })
        if not resp.ok:
            raise Exception(f'Failed to post wiki page on path "{path}". Response: {resp.text}')
