***Описание сервиса с бизнесовой точки зрения будет где-нибудь в https://docs.yandex-team.ru/travel/.
Здесь будем записывать технические фишечки.***
-----------------------

## Обновление
Обновление сейчас работакт так:
1. через grpc запрашиваем обновление за период времени.
  - период времени считается так: от конечной даты последнего запуска, до текущего момента, но не больше недели.
  - вначале запускается обновление заказов, потом обновление биллинговых данных.

2. После обновления через grpc запускается обновление materialized view для заказов (`MaterializedWebViewRefresher`) и более сложная процедура обновления таблицы для страницы платежей (`BankOrderDetailsWebViewUpdater`). `BankOrderDetailsWebViewUpdater` работает еще и в процессе обновления.

3. Это все перезапускается через секунду после завершения. 1 итерация обычно занимает несколько минут (3,5). Но есть нюансы:
 - будет медленнее когда много изменений попадают в короткий промежуток времени (регулярно случается для биллинговых данных);
 - время эксплуатации приложения на момент написания этих строк невелико, может оказаться всё неправдой ;)

*(конфиг работ в BatchConfiguration, запускаются из JobScheduleRunner)*


## Entities

Подход к базе такой, что все сущности, которые выгружаются из других систем,
сохраняются как есть и ничего в них не меняется. Соответственно, любое обновление просто
их переписывает. Отсюда следует вывод, что все данные, которые экстранет делает сам (например,
данные по авторизации) следует хранить отдельно (тупо кладем в отдельную таблицу и следует поосторожнее с внешними
ключами и связями в JPA).

### Materialized web view

Специально для фронта сделаны материализованные вьюхи `<entity>_web_view_v<number>`.
Это решает проблемы с n+1 запросами и то что у нас статус вычисляется на ходу и зависит от текущего времени.
Неконсистентность, которую это добавляет незначительна, учитывая то как к нам данные доходят (заказы с лагом в минуту,
банковский данные в несколько часов).

На данный момент неизвестно куда будет развиваться проект. Если по статусу искать и сортировать не будет нужно
в ближайшей перспективе, а, например, логика вычисления статуса станет сложнее, от materialized view можно отказаться в пользу других решений.

Как предполагается добавление новых столбцов:
1. создать новую версию в миграции, переключить entity на новую версию;
2. старую версию дропнуть (в следующей итерации).

#### BankOrderDetailsWebView

Возникли проблемы с производительностью `REFRESH MATERIALIZED VIEW CONCURRENTLY`. Поскольку в этой таблице нет данных,
протухающих со временем, перешли на другую схему: дописываем данные в настоящую таблицу в конце выполнения работы.


## Удаление записей по работам

*Полезно при разработке, при эксплуатации вредно*

```sql
truncate batch_job_instance CASCADE;
```

Сносит все данные в базе, созданные spring batch'ом. Данные бизнесовые остаются. При перезапуске spring batch начнет
опять все выгружать с начала времён.

## Добавление нового поля

*Мы решили, что нам не хватает какого-нибудь поля из оркестратора:*

1. добавляем поле в `hotels/proto/extranet_api/orders_extract_data.proto`
2. добавляем в сервис на стороне оркестратора (`HotelExtranetService`).
3. добавляем в экстранете поле в entity и миграцию
4. парсим в экстранете поле
5. деплоим всё, убеждаемся что новые поля имеют это поле
6. запускаем update с начала времён (см. след. пункт)

Если надо показывать где-то в API:
1. добавляем поле либо в materialized view, либо в таблицу web_view
2. пишем поле в `hotels/proto/extranet_api/serve_data.proto` -> прокидываем через экстранет
3. пишем поле в `frontend/spec/hotels/extranet/...` -> прокидываем через travel-api
4. в случае с таблицей думаем как обновить данные (поставить флаг forUpdate везде в true?)


## Запуск работы со своими параметрами

Например, если добавили поле, и надо все старые записи перечитать и обновить.
Другой вариант - что-то пошло не так, либо ошибка в конфиге работ, либо руками накосячили со статусами
и хочется просто перезапустить работу.

Для этого есть таблица `manual_override_job_executions`, сделать туда запись можно при помощи процедуры `create_manual_job`, например:

```
CALL create_manual_job(_comment := 'need to restart, after orders update'); -- запустит обновление всех данных с начала времен

CALL create_manual_job(job_names := ARRAY ['Sync Bank Info'],
                       start_at := '2022-11-11T11:11:00',
                       end_at := '2022-11-11T11:11:10',
                       _comment := 'updating bank order info, need to check one thing'); -- обновит биллинговую информацию за 10 секунд в определенный период
```

Для пояснения:
- записи просто перезапишутся на правильные, т.е. это процедура не критичная.
- единственная проблема - время выполнения. Сейчас работы запускаются, сканируя одну неделю. Если запустить manual override с
периодом в пару лет и работа упадёт в середине, при рестарте попытается запуститься с начала, не запомнит промежуточное состояние.
- В связи с предыдущим пунктом лучше использовать баго-фичу: после окончания мануального события, работы продолжаются с даты окончания этого события.

Т.е. паттерн использования такой:
1. Добавили новое поле, которое ожидаем из оркестратора;
2. Сделали миграции и все dto'шки;
3. Создаем новую мануальную миграцию на 1 неделю с начала времён. После окончания этой работы, новая запустится на неделю после заданной
и т.д.
