package ru.yandex.travel.hotels.extranet.cache

import ru.yandex.travel.hotels.proto.THotelId
import ru.yandex.travel.hotels.administrator.export.proto.HotelConnection as HotelConnectionProto

data class HotelConnection(
    val permalink: Long,
    val hotelIdentifier: THotelId,
    val hotelName: String,
    val accountantEmail: String,
    val contractPersonEmail: String,
    var testEmail: String? = null,
) {
    fun getAllEmailsLowerCase(): List<String> {
        val accountantEmails = accountantEmail.split(',')
        val contractPersonEmails = contractPersonEmail.split(',')
        return (accountantEmails + contractPersonEmails + listOfNotNull(testEmail)).map { e -> e.lowercase() }
    }

    fun getTitle(): String {
        return this.hotelName
    }

    companion object {
        fun fromProto(proto: HotelConnectionProto): HotelConnection {
            return HotelConnection(
                permalink = proto.permalink,
                hotelIdentifier = THotelId.newBuilder().setPartnerId(proto.partnerId).setOriginalId(proto.hotelCode)
                    .build(),
                hotelName = proto.hotelName,
                accountantEmail = proto.accountantEmail,
                contractPersonEmail = proto.contractPersonEmail,
            )
        }
    }
}
