package ru.yandex.travel.hotels.extranet.cache

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams
import java.time.Duration

@ConstructorBinding
@ConfigurationProperties(value = "hotel-connections", ignoreUnknownFields = false)
data class HotelConnectionServiceProperties(
    var enabled: Boolean = false,
    var updateInterval: Duration = Duration.ofMinutes(30),
    var shutdownTimeout: Duration = Duration.ofSeconds(10),
    var proxy: MutableList<String> = ArrayList(),
    var token: String,

    var tablePath: String,

    var indexPath: String,
    var preload: Boolean = false,
) {
    fun toYtLuceneIndexParams(): YtLuceneIndexParams {
        return YtLuceneIndexParams().apply {
            this.updateInterval = this@HotelConnectionServiceProperties.updateInterval
            this.shutdownTimeout = this@HotelConnectionServiceProperties.shutdownTimeout
            this.proxy = this@HotelConnectionServiceProperties.proxy
            this.token = this@HotelConnectionServiceProperties.token
            this.tablePath = this@HotelConnectionServiceProperties.tablePath
            this.indexPath = this@HotelConnectionServiceProperties.indexPath
            this.isPreload = this@HotelConnectionServiceProperties.preload
        }
    }
}
