package ru.yandex.travel.hotels.extranet.configuration

import io.opentracing.Tracer
import org.asynchttpclient.AsyncHttpClient
import org.asynchttpclient.Dsl
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper
import ru.yandex.travel.hotels.extranet.service.blackbox.BlackBoxServiceImpl

@Configuration
@EnableConfigurationProperties(AsyncHttpClientCommonProperties::class)
open class AsyncHttpClientAutoConfiguration(
    var asyncHttpClientCommonProperties: AsyncHttpClientCommonProperties
) {

    @Bean
    open fun defaultAsyncHttpClient(): AsyncHttpClient {
        return Dsl.asyncHttpClient(
            Dsl.config()
                .setThreadPoolName("ahcHttpClientPool")
                .setIoThreadsCount(asyncHttpClientCommonProperties.ioThreads)
                .build()
        )
    }

    @Bean
    open fun mailerAsyncHttpClientWrapper(
        @Qualifier("defaultAsyncHttpClient") client: AsyncHttpClient,
        tracer: Tracer?
    ): AsyncHttpClientWrapper {
        return AsyncHttpClientWrapper(
            client,
            LoggerFactory.getLogger("travel.hotel.extranet.MailSenderService"),
            "mailSender",
            tracer,
        )
    }

    @Bean
    open fun blackboxAsyncHttpClientWrapper(
        @Qualifier("defaultAsyncHttpClient") client: AsyncHttpClient,
        tracer: Tracer?
    ): AsyncHttpClientWrapper {
        return AsyncHttpClientWrapper(
            client,
            LoggerFactory.getLogger(BlackBoxServiceImpl::class.java),
            "blackBoxClient",
            tracer,
        )
    }
}
