package ru.yandex.travel.hotels.extranet.entities

import javax.persistence.Embeddable
import javax.persistence.EnumType
import javax.persistence.Enumerated

@Embeddable
class AnnulationRuleStart(
    val amount: Int,
    @Enumerated(EnumType.STRING)
    val unit: Unit
) {

    enum class Unit {
        DAYS,
        HOURS
    }

    fun describe(): String =
        when (this.unit) {
            Unit.DAYS -> "$amount суток"
            Unit.HOURS -> "$amount часов"
        }
}
