package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.Embedded
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.ManyToOne
import javax.persistence.SequenceGenerator
import javax.persistence.Table

@Entity
@Table(name = "hotels")
class Hotel(
    @ManyToOne
    var organization: Organization,

    var name: String,

    @Enumerated(EnumType.STRING)
    val managedBy: HotelManagementSource? = HotelManagementSource.YANDEX,

    @Embedded
    val partnerHotelId: HotelIdentifier? = null,

    ) {
    @Id
    @GeneratedValue(
        strategy = GenerationType.SEQUENCE,
        generator = "hotels_id_seq"
    )
    @SequenceGenerator(name = "hotels_id_seq", sequenceName = "hotels_id_seq", allocationSize = 1)
    val id: Long? = null

    var permalink: Long? = null

    @CreationTimestamp
    var createdAt: Instant = Instant.now()

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now()

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other is Hotel) {
            return id == other.id
        }
        return false
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
