package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.NaturalId
import org.hibernate.annotations.UpdateTimestamp
import ru.yandex.travel.hotels.extranet.entities.orders.BoYOrder
import java.time.Instant
import javax.persistence.Embedded
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.OneToMany
import javax.persistence.Table

@Entity
@Table(name = "hotel_agreements")
open class HotelAgreement(
    // TODO check with orders db that the id is really unique, it doesn't seem like that on testing
    @Id
    var id: Long = -1,

    @Embedded
    var hotelIdentifier: HotelIdentifier = HotelIdentifier(),

    var financialClientId: Long = -1,
    var financialContractId: Long = -1,

    var orderConfirmedRate: String = "",
    var orderRefundedRate: String = "",

    var agreementEndDate: Instant? = null,
    var agreementStartDate: Instant = Instant.EPOCH,

    var fullLegalName: String? = null,
    /**
     * ATM not quite clear how we'll gonna use it, it might go to hotelIdentifier and by different name. For now let's
     * fill the db with it.
     */
    var externalHotelId: String? = null,

    @OneToMany(mappedBy = "hotelAgreement")
    var orders: MutableList<BoYOrder> = mutableListOf(),

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),
)
