package ru.yandex.travel.hotels.extranet.entities

import ru.yandex.travel.hotels.proto.EPartnerId
import ru.yandex.travel.hotels.proto.THotelId
import javax.persistence.Embeddable
import javax.persistence.EnumType
import javax.persistence.Enumerated

@Embeddable
data class HotelIdentifier(
    @Enumerated(EnumType.STRING)
    var partnerId: EPartnerId = EPartnerId.UNRECOGNIZED,
    var originalId: String = "",
) {
    fun toProto(): THotelId {
        return THotelId.newBuilder()
            .setPartnerId(this.partnerId)
            .setOriginalId(this.originalId)
            .build()
    }

    companion object {
        fun fromProto(hotelId: THotelId): HotelIdentifier {
            return HotelIdentifier(hotelId.partnerId, hotelId.originalId)
        }
    }
}
