package ru.yandex.travel.hotels.extranet.entities

import ru.yandex.travel.hotels.proto.EPartnerId

enum class HotelManagementSource {
    YANDEX,
    TRAVELLINE,
    BNOVO;

    companion object {
        fun fromPartnerId(partnerIdentifier: EPartnerId): HotelManagementSource? {
            return when (partnerIdentifier) {
                EPartnerId.PI_TRAVELLINE -> TRAVELLINE
                EPartnerId.PI_BNOVO -> BNOVO
                else -> null
            }
        }
    }
}
