package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import ru.yandex.travel.hotels.extranet.IDMRoleType
import java.time.Instant
import java.util.*
import javax.persistence.*

@Entity
@Table(
    name = "idm_permissions",
    indexes = [
        Index(columnList = "login"),
        Index(columnList = "passport_login")
    ],
)
open class IdmPermission(
    @Id
    var id: UUID = UUID.randomUUID(),
    @Column(name = "login")
    var login: String = "",
    @Column(name = "passport_login")
    var passportLogin: String = "",
    @Column(name = "passport_uid")
    var passportUid: Long? = null,
    @Column(name = "role")
    var role: IDMRoleType = IDMRoleType.IDM_ROLE_TYPE_INVALID,
    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),
)

