package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import java.util.UUID
import javax.persistence.Embedded
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.Table

@Entity
@Table(name = "invitations")
open class Invitation(
    @Id
    var id: UUID = UUID.randomUUID(),

    @Embedded
    var hotelIdentifier: HotelIdentifier = HotelIdentifier(),

    var passportId: String = "",
    var requestToken: String = "",
    var requestExpiresAt: Instant = Instant.now(),
    var approvedAt: Instant? = null,

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),
)

