package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.Table

/**
 * For manual interventions. For instance, if a new field has been added
 * and old data needs to be updated.
 */
@Entity
@Table(name = "manual_override_job_executions")
open class ManualOverrideJobExecution(

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "manual_override_job_executions_id_seq")
    var id: Long = -1,

    /**
     * Required to be defined.
     */
    var jobName: String = "",

    var fromProp: Instant = Instant.MAX,

    var tillProp: Instant? = null,

    @Enumerated(EnumType.STRING)
    var state: ManualOverrideState = ManualOverrideState.NEW,

    /**
     * Solely for documenting the reasons.
     */
    var comment: String = "",

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),
)

enum class ManualOverrideState {
    NEW,
    STARTED,
}
