package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import java.util.*
import javax.persistence.CascadeType
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.OneToMany
import javax.persistence.Table

@Entity
@Table(name = "organizations")
class Organization(
    @Column var name: String,
) {
    @Id
    val id: UUID = UUID.randomUUID()

    @OneToMany(mappedBy = "organization", cascade = [CascadeType.ALL])
    val hotels: MutableList<Hotel> = mutableListOf()


    @OneToMany(mappedBy = "organization", cascade = [CascadeType.ALL])
    val users: MutableSet<UserRoleBinding> = mutableSetOf()

    @CreationTimestamp
    var createdAt: Instant = Instant.now()

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now()

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other is Organization) {
            return other.id == id
        }

        return false
    }

    override fun hashCode(): Int {
        return javaClass.hashCode()
    }


}
