package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.JoinTable
import javax.persistence.ManyToMany
import javax.persistence.ManyToOne
import javax.persistence.SequenceGenerator
import javax.persistence.Table

@Entity
@Table(name = "rate_plans")
class RatePlan(
    @ManyToOne
    val hotel: Hotel,

    @ManyToOne
    var annulationPolicy: AnnulationPolicy,

    var name: String,

    var description: String? = null,

    @ManyToMany(targetEntity = RoomCategory::class)
    @JoinTable(
        name = "rate_plans_to_room_categories",
        joinColumns = [JoinColumn(name = "rate_plan_id")],
        inverseJoinColumns = [JoinColumn(name = "room_category_id")]
    )
    var roomCategories: Set<RoomCategory> = emptySet(),
) {
    @Id
    @GeneratedValue(
        strategy = GenerationType.SEQUENCE,
        generator = "rate_plans_id_seq"
    )
    @SequenceGenerator(name = "rate_plans_id_seq", sequenceName = "rate_plans_id_seq", allocationSize = 1)
    val id: Long? = null

    var deleted: Boolean = false

    var hidden: Boolean = false

    var disabled: Boolean = false

    @CreationTimestamp
    val createdAt: Instant = Instant.now()

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now()

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other is RatePlan) {
            return id == other.id
        }
        return false
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
