package ru.yandex.travel.hotels.extranet.entities

import ru.yandex.travel.hotels.extranet.IDMRoleType
import ru.yandex.travel.hotels.extranet.utils.enumSetOf
import java.util.EnumSet

enum class Role(
    val permissions: EnumSet<Permission>,
    val allowsHotelLevel: Boolean = true,
    val displayNameRu: String? = null,
    val displayNameEn: String? = null,
    val idmRoleType: IDMRoleType? = null,
) {
    OWNER(
        permissions = enumSetOf(*Permission.values()),
        allowsHotelLevel = false,
        displayNameRu = "Владелец",
    ),
    OPERATOR(
        permissions = enumSetOf(Permission.VIEW_USERS, Permission.VIEW_HOTELS, Permission.VIEW_ROOM_TYPES),
        displayNameRu = "Оператор",
    ),
    MINOR_EXTRANET_VIEWER(
        permissions = enumSetOf(
            Permission.VIEW_HOTELS,
            Permission.VIEW_PAYMENTS,
            Permission.VIEW_AGREEMENTS,
            Permission.VIEW_ROOM_TYPES
        )
    ),
    IDM_DEVELOPER(
        enumSetOf(*Permission.values()),
        displayNameRu = "Разработчик",
        displayNameEn = "Developer",
        idmRoleType = IDMRoleType.IDM_ROLE_TYPE_DEVELOPER
    ),
    IDM_ACCOUNT_MANAGER(
        enumSetOf(
            Permission.VIEW_USERS,
            Permission.VIEW_HOTELS,
            Permission.VIEW_ORDERS,
            Permission.VIEW_PAYMENTS,
        ),
        displayNameRu = "Аккаунт-менеджер",
        displayNameEn = "Account Manager",
        idmRoleType = IDMRoleType.IDM_ROLE_TYPE_ACCOUNT_MANAGER,
    );

    val isIdmManaged: Boolean
        get() = this.idmRoleType != null

    companion object {
        fun fromIdmRoleType(roleType: IDMRoleType): Role {
            return Role.values().asList().find { it.idmRoleType == roleType }
                ?: throw IllegalArgumentException("Unexpected IDM role type")
        }
    }
}

enum class Permission {
    VIEW_USERS,
    MANAGE_USERS,
    VIEW_HOTELS,
    MANAGE_HOTELS,
    VIEW_AGREEMENTS,
    MANAGE_AGREEMENTS,
    VIEW_ORDERS,
    VIEW_PAYMENTS,
    VIEW_ROOM_TYPES,
    MANAGE_ROOM_TYPES,
    MANAGE_ANNULATION_POLICIES,
    MANAGE_RATE_PLANS,
}

