package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.CascadeType
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.ManyToOne
import javax.persistence.OneToMany
import javax.persistence.OrderColumn
import javax.persistence.SequenceGenerator
import javax.persistence.Table

@Entity
@Table(name = "room_categories")
class RoomCategory(
    @ManyToOne
    val hotel: Hotel,

    var name: String,

    @Enumerated(value = EnumType.STRING)
    var type: RoomCategoryType = RoomCategoryType.HOTEL_ROOM,

    var maxPrimaryPlaces: Int,

    var maxExtraPlaces: Int = 0,
) {
    @Id
    @GeneratedValue(
        strategy = GenerationType.SEQUENCE,
        generator = "room_categories_id_seq"
    )
    @SequenceGenerator(name = "room_categories_id_seq", sequenceName = "room_categories_id_seq", allocationSize = 1)
    val id: Long? = null

    var description: String? = null

    @OneToMany(mappedBy = "roomCategory", cascade = [CascadeType.ALL], orphanRemoval = true)
    @OrderColumn(name = "item_id")
    val placements: MutableList<RoomPlacement> = mutableListOf()

    var deleted: Boolean = false

    var hidden: Boolean = false

    var disabled: Boolean = false

    @CreationTimestamp
    val createdAt: Instant = Instant.now()

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now()

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other is RoomCategory) {
            return id == other.id
        }
        return false
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
