package ru.yandex.travel.hotels.extranet.entities

import ru.yandex.travel.hotels.extranet.dto.RoomCategoryType as RoomCategoryTypeDTO

enum class RoomCategoryType(val displayName: String, val protoType: RoomCategoryTypeDTO) {
    HOTEL_ROOM("Номер в гостинице", RoomCategoryTypeDTO.ROOM_CATEGORY_TYPE_HOTEL_ROOM),
    HOTEL_APARTMENT("Апартаменты в гостинице", RoomCategoryTypeDTO.ROOM_CATEGORY_TYPE_HOTEL_APARTMENT),
    FLAT("Квартира, сдаваемая посуточно", RoomCategoryTypeDTO.ROOM_CATEGORY_TYPE_FLAT),
    BED("Койко-место в общем номере", RoomCategoryTypeDTO.ROOM_CATEGORY_TYPE_BED),
    COTTAGE("Отдельно стоящий дом, коттедж", RoomCategoryTypeDTO.ROOM_CATEGORY_TYPE_COTTAGE),
    VILLA("Вилла", RoomCategoryTypeDTO.ROOM_CATEGORY_TYPE_VILLA);

    companion object {
        fun fromProto(proto: RoomCategoryTypeDTO): RoomCategoryType {
            for (v in RoomCategoryType.values()) {
                if (v.protoType == proto) {
                    return v
                }
            }
            throw IllegalArgumentException("Unknown RoomCategoryType proto value")
        }
    }
}
