package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.ManyToOne
import javax.persistence.SequenceGenerator
import javax.persistence.Table

@Entity
@Table(name = "room_placements")
class RoomPlacement(
    @ManyToOne
    var roomCategory: RoomCategory,
    var name: String,
    var primaryAdults: Int,
    var extraAdults: Int = 0,
) {
    @Id
    @GeneratedValue(
        strategy = GenerationType.SEQUENCE,
        generator = "room_placements_id_seq"
    )
    @SequenceGenerator(name = "room_placements_id_seq", sequenceName = "room_placements_id_seq", allocationSize = 1)
    val id: Long? = null

    var deleted: Boolean = false

    var hidden: Boolean = false

    var disabled: Boolean = false

    @CreationTimestamp
    val createdAt: Instant = Instant.now()

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now()

}
