package ru.yandex.travel.hotels.extranet.entities

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.time.Instant
import javax.persistence.*

@Entity
@Table(name = "users")
class User(
    @Id
    val uid: Long,

    var login: String? = null,
) {
    @OneToMany(mappedBy = "user", cascade = [CascadeType.ALL])
    val roles: MutableSet<UserRoleBinding> = mutableSetOf()

    var blocked: Boolean = false

    @CreationTimestamp
    val createdAt: Instant = Instant.now()

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now()


    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other is User) {
            return uid == other.uid
        }
        return false
    }

    override fun hashCode(): Int {
        return uid.hashCode()
    }
}
