package ru.yandex.travel.hotels.extranet.entities

import java.util.*
import javax.persistence.*

@Entity
@Table(name = "user_role_bindings")
open class UserRoleBinding(
    @ManyToOne
    @JoinColumn(name = "user_uid")
    val user: User,

    @Enumerated(value = EnumType.STRING)
    val role: Role,

    @ManyToOne
    @JoinColumn(name = "organization_id")
    open val organization: Organization? = null,

    @ManyToOne
    @JoinColumn(name = "hotel_id")
    open val hotel: Hotel? = null,

    val idmLogin: String? = null,

    ) {
    @Id
    val id: UUID = UUID.randomUUID()

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other is UserRoleBinding) {
            return id == other.id
        }
        return false
    }

    override fun hashCode(): Int {
        return id.hashCode()
    }


}


