package ru.yandex.travel.hotels.extranet.entities.orders

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import java.math.BigDecimal
import java.time.Instant
import java.time.LocalDate
import javax.persistence.CascadeType
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.OneToMany
import javax.persistence.Table

const val FETCHED_STATUS = "fetched"

@Entity
@Table(name = "bank_orders")
open class BankOrder(
    @Id
    var paymentBatchId: String = "",

    var bankOrderId: String = "",

    var status: String = "",
    var oebsStatus: String = "",
    var sum: BigDecimal = BigDecimal.ZERO,
    var description: String = "",

    @OneToMany(cascade = [CascadeType.ALL], mappedBy = "bankOrder")
    var bankOrderDetails: MutableList<BankOrderDetail> = mutableListOf(),

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),

    var eventTime: LocalDate = LocalDate.EPOCH,

    var updatedAtInOrc: Instant = Instant.EPOCH,

    /** BankOrderPaymentDetailsStatus enum's values from the orders app */
    var fetchStatus: String = "",

    /**
     * As we don't have a reliable way to filter out Dolphin's bank orders, we'll give up after some attempts
     */
    var calculateAttempts: Int = 0,
) {
    val isFetched: Boolean get() = fetchStatus == FETCHED_STATUS
}
