package ru.yandex.travel.hotels.extranet.entities.orders

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionPaymentType
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType
import java.math.BigDecimal
import java.time.Instant
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.Table

@Entity
@Table(name = "bank_order_details")
open class BankOrderDetail(
    @Id
    var id: Long = 0,

    var trustPaymentId: Int = 0,

    var sum: BigDecimal = BigDecimal.ZERO,

    var agencyCommission: BigDecimal? = null,

    var contractId: Long = 0,

    var handlingTime: Instant = Instant.EPOCH,
    var paymentTime: Instant = Instant.EPOCH,

    @Enumerated(EnumType.STRING)
    var paymentType: EBankOrderTransactionPaymentType = EBankOrderTransactionPaymentType.BTPT_UNKNOWN,
    @Enumerated(EnumType.STRING)
    var transactionType: EBankOrderTransactionTransactionType = EBankOrderTransactionTransactionType.BTTT_UNKNOWN,

    var ytId: Long = 0,

    @ManyToOne
    @JoinColumn(name = "payment_batch_id")
    var bankOrder: BankOrder = BankOrder(),

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),
) {
    private fun signed(price: BigDecimal): BigDecimal {
        return when (transactionType) {
            EBankOrderTransactionTransactionType.BTTT_REFUND ->
                price.negate()
            else ->
                price
        }
    }

    val signedSum: BigDecimal get() = signed(sum)
}
