package ru.yandex.travel.hotels.extranet.entities.orders

import ru.yandex.travel.commons.proto.TPrice
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType
import ru.yandex.travel.hotels.extranet.entities.HotelIdentifier
import ru.yandex.travel.hotels.extranet.service.toTPrice
import java.math.BigDecimal
import java.time.Instant
import java.time.LocalDate
import javax.persistence.EmbeddedId
import javax.persistence.Entity
import javax.persistence.Table

/**
 * Represents conveniently stored data for web page. Doesn't hold unique data.
 *
 * @implNote: this approach was taken after other unsuccessful attempts to:
 * 1. to add indexes and calculate on the fly;
 * 2. to have a materialized view and refresh it CONCURRENTLY after each job execution.
 */
@Entity
@Table(name = "bank_order_details_web_view")
open class BankOrderDetailWebView(
    @EmbeddedId
    var id: BankOrderDetailsWebViewIdx = BankOrderDetailsWebViewIdx(),

    var hotelId: HotelIdentifier? = HotelIdentifier(),

    var prettyId: String = "",

    var paidAmount: BigDecimal = BigDecimal.ZERO,
    var agencyCommission: BigDecimal? = null,

    var guestFirstName: String? = null,
    var guestLastName: String? = null,

    var fiscalPrice: BigDecimal? = null,
    var hotelPrice: BigDecimal? = null,

    var orderCreatedAt: Instant = Instant.EPOCH,

    var checkInDate: LocalDate = LocalDate.EPOCH,
    var checkOutDate: LocalDate = LocalDate.EPOCH,

    var forUpdate: Boolean = false,
) {
    private fun signed(price: BigDecimal?): BigDecimal? {
        when (id.transactionType) {
            EBankOrderTransactionTransactionType.BTTT_REFUND ->
                return price?.negate()
            else ->
                return price
        }
    }

    val signedPaidAmount: BigDecimal? get() = signed(paidAmount)
    val signedAgencyCommission: BigDecimal? get() = signed(agencyCommission)
    val signedFiscalPrice: BigDecimal? get() = signed(fiscalPrice)
    val signedHotelPrice: BigDecimal? get() = signed(hotelPrice)
}
