package ru.yandex.travel.hotels.extranet.entities.orders

import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType
import java.io.Serializable
import javax.persistence.Embeddable
import javax.persistence.EnumType
import javax.persistence.Enumerated

@Embeddable
open class BankOrderDetailsWebViewIdx(
    var paymentBatchId: String = "",
    var bankOrderId: String = "",
    var orderId: String = "",
    @Enumerated(EnumType.STRING)
    var transactionType: EBankOrderTransactionTransactionType = EBankOrderTransactionTransactionType.BTTT_UNKNOWN,
) : Serializable {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BankOrderDetailsWebViewIdx

        if (paymentBatchId != other.paymentBatchId) return false
        if (bankOrderId != other.bankOrderId) return false
        if (orderId != other.orderId) return false
        if (transactionType != other.transactionType) return false

        return true
    }

    override fun hashCode(): Int {
        var result = paymentBatchId.hashCode()
        result = 31 * result + bankOrderId.hashCode()
        result = 31 * result + (orderId?.hashCode() ?: 0)
        result = 31 * result + transactionType.hashCode()
        return result
    }

    override fun toString(): String {
        return "BankOrderDetailsWebViewIdx(paymentBatchId='$paymentBatchId', bankOrderId='$bankOrderId', " +
            "transactionType=$transactionType)"
    }
}
