package ru.yandex.travel.hotels.extranet.entities.orders

import ru.yandex.travel.hotels.extranet.EBankOrderTransactionPaymentType
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType
import java.math.BigDecimal
import java.time.Instant
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.Table

@Entity
@Table(name = "billing_transactions")
open class BillingTransaction(
    @Id
    var id: Long = -1,

    @Enumerated(EnumType.STRING)
    var transactionType: EBankOrderTransactionTransactionType = EBankOrderTransactionTransactionType.UNRECOGNIZED,
    @Enumerated(EnumType.STRING)
    var paymentType: EBankOrderTransactionPaymentType = EBankOrderTransactionPaymentType.UNRECOGNIZED,

    var value: BigDecimal = BigDecimal.ZERO,

    var createdAtBillingTransaction: Instant = Instant.EPOCH,
    var payoutAt: Instant? = null,
    var accountingActAt: Instant? = null,

    var exportedToYt: Boolean = false,
    var actCommitted: Boolean = false,
    var ytId: Long? = null,

    @ManyToOne
    @JoinColumn(name = "financial_event_id")
    var financialEvent: FinancialEvent = FinancialEvent(),
)
