package ru.yandex.travel.hotels.extranet.entities.orders

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.NaturalId
import org.hibernate.annotations.UpdateTimestamp
import ru.yandex.travel.hotels.extranet.entities.HotelAgreement
import ru.yandex.travel.hotels.extranet.extract.grpc.PaymentInfo
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState
import java.math.BigDecimal
import java.time.Instant
import java.time.LocalDate
import javax.persistence.CascadeType
import javax.persistence.Embedded
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.FetchType
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.OneToMany
import javax.persistence.Table

/**
 * DBoy Hotel order.
 *
 * The entity contains data from HotelOrder and HotelOrderItem from the order's db.
 */
@Entity
@Table(name = "boy_orders")
open class BoYOrder(
    /** GUID */
    @Id
    var id: String = "",

    @NaturalId
    var prettyId: String = "",

    var partnerOrderId: String? = "",

    @Enumerated(EnumType.STRING)
    var hotelOrderState: EHotelOrderState? = null,

    var orderCreatedAt: Instant = Instant.EPOCH,
    var orderUpdatedAt: Instant = Instant.EPOCH,
    var orderCancelledAt: Instant? = null,

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),
    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),

    @OneToMany(cascade = [CascadeType.ALL], mappedBy = "id.order", fetch = FetchType.EAGER)
    var guests: MutableList<Guest> = mutableListOf(),

    var checkInDate: LocalDate = LocalDate.EPOCH,
    var checkOutDate: LocalDate = LocalDate.EPOCH,

    var hotelPrice: BigDecimal = BigDecimal.ZERO,
    var fiscalPrice: BigDecimal = BigDecimal.ZERO,
    var discount: BigDecimal? = null,
    var costAfterReservation: BigDecimal? = null,
    var paidAmount: BigDecimal? = null,

    @Embedded
    var paymentInfo: PaymentInfo = PaymentInfo(),

    @OneToMany(mappedBy = "order", cascade = [CascadeType.ALL])
    var financialEvents: MutableList<FinancialEvent> = mutableListOf(),

    @ManyToOne(cascade = [CascadeType.ALL])
    @JoinColumn(name = "hotel_agreement_id")
    var hotelAgreement: HotelAgreement? = null,
) {
    val fee: BigDecimal?
        get() {
            return financialEvents
                .map { it.feeAmount }
                .reduceOrNull(fun(fee1, fee2): BigDecimal {
                    return fee1.add(fee2)
                })
        }

    val partner: BigDecimal?
        get() {
            return financialEvents
                .map { it.partnerAmount }
                .reduceOrNull(fun(fee1, fee2): BigDecimal {
                    return fee1.add(fee2)
                })
        }
}
