package ru.yandex.travel.hotels.extranet.entities.orders

import org.hibernate.annotations.Immutable
import org.hibernate.annotations.Type
import ru.yandex.travel.hotels.extranet.EExtranetOrderStatus
import ru.yandex.travel.hotels.extranet.entities.HotelIdentifier
import ru.yandex.travel.hotels.extranet.extract.grpc.PaymentInfo
import java.math.BigDecimal
import java.time.Instant
import java.time.LocalDate
import javax.persistence.Column
import javax.persistence.Embedded
import javax.persistence.Entity
import javax.persistence.EnumType
import javax.persistence.Enumerated
import javax.persistence.Id
import javax.persistence.Table

const val BOY_ORDER_VIEW_NAME = "boy_orders_web_view_v2"

@Entity
@Immutable
@Table(name = BOY_ORDER_VIEW_NAME)
open class BoYOrderWebView(
    @Id
    var id: String = "",

    var prettyId: String = "",

    var partnerOrderId: String? = "",

    @Column(name = "order_created_at")
    var createdAt: Instant = Instant.EPOCH,
    @Column(name = "order_updated_at")
    var updatedAt: Instant = Instant.EPOCH,

    @Column(name = "order_cancelled_at")
    var cancelledAt: Instant? = null,

    var checkInDate: LocalDate = LocalDate.EPOCH,
    var checkOutDate: LocalDate = LocalDate.EPOCH,

    var hotelPrice: BigDecimal = BigDecimal.ZERO,
    var fiscalPrice: BigDecimal = BigDecimal.ZERO,
    var discount: BigDecimal? = null,
    var costAfterReservation: BigDecimal? = null,
    var paidAmount: BigDecimal? = null,

    @Embedded
    var paymentInfo: PaymentInfo = PaymentInfo(),
    @Embedded
    var hotelId: HotelIdentifier = HotelIdentifier(),

    var payoutAt: Instant? = null,
    var guestFirstName: String? = null,
    var guestLastName: String? = null,
    @Enumerated(EnumType.STRING)
    var orderStatus: EExtranetOrderStatus = EExtranetOrderStatus.EOS_UNKNOWN,
    var orderStatusRus: String? = null,
    var feeAmount: BigDecimal? = null,
    var partnerAmount: BigDecimal? = null,

    @Column(columnDefinition = "text[]")
    @Type(type = "ru.yandex.travel.hotels.extranet.utils.PgListType")
    var bankOrdersArray: List<String>? = null,

)
