package ru.yandex.travel.hotels.extranet.entities.orders

import java.math.BigDecimal
import java.time.Instant
import javax.persistence.CascadeType
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.OneToMany
import javax.persistence.Table

@Entity
@Table(name = "financial_events")
open class FinancialEvent(
    @Id
    var id: Long = 0,

    @ManyToOne
    @JoinColumn(name = "order_id")
    var order: BoYOrder = BoYOrder(),

    var billingClientId: Long = -1,
    var billingContractId: Long = -1,

    var partnerAmount: BigDecimal = BigDecimal.ZERO,
    var feeAmount: BigDecimal = BigDecimal.ZERO,

    var promoCodePartnerAmount: BigDecimal? = null,
    var promoCodeFeeAmount: BigDecimal? = null,

    var plusPartnerAmount: BigDecimal? = null,
    var plusFeeAmount: BigDecimal? = null,

    var payoutAt: Instant? = null,

    @OneToMany(mappedBy = "financialEvent", cascade = [CascadeType.ALL])
    var billingTransactions: MutableList<BillingTransaction> = mutableListOf(),
)
