package ru.yandex.travel.hotels.extranet.entities.orders

import ru.yandex.travel.hotels.extranet.TGuest
import javax.persistence.EmbeddedId
import javax.persistence.Entity
import javax.persistence.Table

@Entity
@Table(name = "guests")
open class Guest(
    @EmbeddedId
    var id: GuestOrderIdx = GuestOrderIdx(),

    var firstName: String? = null,
    var lastName: String? = null,

    var isChild: Boolean = false,

    var age: Int? = null
) {
    fun toProto(): TGuest {
        val proto = TGuest.newBuilder()

        proto.firstName = this.firstName
        proto.lastName = this.lastName

        return proto.build()
    }
}
