package ru.yandex.travel.hotels.extranet.entities.orders

import java.io.Serializable
import javax.persistence.Embeddable
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.OrderBy

@Embeddable
open class GuestOrderIdx(
    @ManyToOne
    @JoinColumn(name = "order_id")
    var order: BoYOrder = BoYOrder(),

    /**
     * 1-based # of the guest in the order
     */
    @OrderBy
    var guestIdx: Int = 0,
) : Serializable {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GuestOrderIdx

        if (order != other.order) return false
        if (guestIdx != other.guestIdx) return false

        return true
    }

    override fun hashCode(): Int {
        var result = order.hashCode()
        result = 31 * result + guestIdx
        return result
    }

    override fun toString(): String {
        return "GuestOrderIdx(order=$order, guestIdx=$guestIdx)"
    }
}
