package ru.yandex.travel.hotels.extranet.extract.grpc

import org.springframework.batch.item.ItemProcessor
import ru.yandex.travel.commons.proto.ProtoUtils
import ru.yandex.travel.hotels.extranet.TBankOrderInfo
import ru.yandex.travel.hotels.extranet.TBankOrderInfoDetail
import ru.yandex.travel.hotels.extranet.entities.orders.BankOrder
import ru.yandex.travel.hotels.extranet.entities.orders.BankOrderDetail
import java.math.BigDecimal

class BankOrderIntermediateProcessor : ItemProcessor<TBankOrderInfo, BankOrder> {

    override fun process(proto: TBankOrderInfo): BankOrder {
        val bankOrder = BankOrder(
            paymentBatchId = proto.paymentBatchId,
            bankOrderId = proto.bankOrderId,
            status = proto.status,
            oebsStatus = proto.oebsStatus,
            sum = BigDecimal(proto.sum),
            description = proto.description,
            updatedAtInOrc = proto.updatedAt.instant(),
            fetchStatus = proto.fetchStatus,
            eventTime = ProtoUtils.toLocalDate(proto.eventTime),
        )
        bankOrder.bankOrderDetails = proto.detailsList.map {
            protoToBankOrderDetail(it, bankOrder)
        }.toMutableList()
        return bankOrder
    }

    private fun protoToBankOrderDetail(proto: TBankOrderInfoDetail, bankOrder: BankOrder) =
        BankOrderDetail(
            id = proto.id,
            trustPaymentId = proto.trustPaymentId.toInt(),
            sum = BigDecimal(proto.sum),
            agencyCommission = proto.agencyCommission.toBigDecimalOrNull(),
            contractId = proto.contractId,
            handlingTime = proto.handlingTime.instant(),
            paymentType = proto.paymentType,
            paymentTime = proto.paymentTime.instant(),
            bankOrder = bankOrder,
            transactionType = proto.transactionType,
            ytId = proto.ytId,
        )
}
