package ru.yandex.travel.hotels.extranet.extract.grpc

import com.google.protobuf.Timestamp
import ru.yandex.travel.hotels.extranet.OrdersHotelsExtranetDataServiceGrpc
import ru.yandex.travel.hotels.extranet.TBankOrderInfo
import ru.yandex.travel.hotels.extranet.TGetDBoyReq
import ru.yandex.travel.hotels.extranet.TGetDBoyRsp
import java.time.Instant

open class BankOrdersGrpcReader(
    clientFactory: OrdersGrpcClientFactory,
    apiProperties: OrdersGrpcProperties,
    from: Instant = apiProperties.startAt,
    to: Instant = Instant.now(),
) : AbstractGrpcReader<TBankOrderInfo>(clientFactory, apiProperties, from, to) {

    init {
        this.setName("BankOrderReader")
    }

    override fun grpcFunction(
        protoReq: TGetDBoyReq.Builder,
        service: OrdersHotelsExtranetDataServiceGrpc.OrdersHotelsExtranetDataServiceBlockingStub
    ): TGetDBoyRsp = service.getDBoyBankOrderInfo(protoReq.build())

    override fun getUpdatedAt(last: TBankOrderInfo): Timestamp = last.updatedAt

    override fun getList(response: TGetDBoyRsp): List<TBankOrderInfo> = response.bankOrdersList
}
