package ru.yandex.travel.hotels.extranet.extract.grpc

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.validation.annotation.Validated
import ru.yandex.travel.orders.client.FailureDetectorProperties
import ru.yandex.travel.orders.client.GrpcChannelSupplierMode
import ru.yandex.travel.orders.client.GrpcChannelSupplierProperties
import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties
import java.time.Duration
import java.time.Instant
import java.time.temporal.ChronoUnit
import java.util.Collections
import javax.validation.Valid
import javax.validation.constraints.NotNull

@ConstructorBinding
@ConfigurationProperties(value = "orchestrator.grpc")
@Validated
data class OrdersGrpcProperties(
    private var targets: List<String> = Collections.emptyList(),

    private var yp: @Valid YpDiscoveryProperties = YpDiscoveryProperties(),

    private var mode: @Valid @NotNull GrpcChannelSupplierMode = GrpcChannelSupplierMode.EMPTY,

    var timeout: @NotNull Duration = Duration.of(5, ChronoUnit.SECONDS),

    var failureDetection: @Valid FailureDetectorProperties? = null,

    var tvm: Tvm? = null,

    var maxMessageSize: Int = 10485760,

    var limit: Int = 100,

    var startAt: Instant = Instant.now(),

    var checkoutSpan: Duration = Duration.of(7, ChronoUnit.DAYS),

    ) : GrpcChannelSupplierProperties {

    override fun getTargets(): List<String> = targets
    fun setTargets(targets: List<String>) {
        this.targets = targets
    }

    override fun getMode(): GrpcChannelSupplierMode = mode
    fun setMode(mode: GrpcChannelSupplierMode) {
        this.mode = mode
    }

    override fun getYp(): YpDiscoveryProperties = yp
    fun setYp(yp: YpDiscoveryProperties) {
        this.yp = yp
    }
}

@Validated
data class Tvm(
    var enabled: Boolean = false,
    var destinationAlias: String = ""
)
