package ru.yandex.travel.hotels.extranet.extract.grpc

import com.google.protobuf.Timestamp
import ru.yandex.travel.hotels.extranet.OrdersHotelsExtranetDataServiceGrpc
import ru.yandex.travel.hotels.extranet.TDBoyOrder
import ru.yandex.travel.hotels.extranet.TGetDBoyReq
import ru.yandex.travel.hotels.extranet.TGetDBoyRsp
import java.time.Instant

open class OrdersGrpcReader(
    clientFactory: OrdersGrpcClientFactory,
    apiProperties: OrdersGrpcProperties,
    from: Instant = apiProperties.startAt,
    to: Instant = Instant.now(),
) : AbstractGrpcReader<TDBoyOrder>(clientFactory, apiProperties, from, to) {
    override fun grpcFunction(
        protoReq: TGetDBoyReq.Builder,
        service: OrdersHotelsExtranetDataServiceGrpc.OrdersHotelsExtranetDataServiceBlockingStub
    ): TGetDBoyRsp = service.getDBoyOrderInfo(protoReq.build())

    override fun getUpdatedAt(last: TDBoyOrder): Timestamp = last.updatedAt

    override fun getList(response: TGetDBoyRsp): List<TDBoyOrder> = response.ordersList
}
