package ru.yandex.travel.hotels.extranet.extract.grpc

import org.springframework.batch.core.BatchStatus
import org.springframework.batch.core.JobParameters
import org.springframework.batch.core.JobParametersBuilder
import org.springframework.batch.core.JobParametersIncrementer
import org.springframework.batch.core.repository.JobRepository
import ru.yandex.travel.hotels.extranet.service.IManualJobOverrideService
import java.time.Instant
import java.util.Date

const val FROM_PROP = "run.from"
const val TILL_PROP = "run.till"
const val STARTED_AT = "run.started"
const val MANUAL_OVERRIDE = "manualOverride"

class UpdateDateRunIncrementer(
    var props: OrdersGrpcProperties,
    var jobRepository: JobRepository,
    var jobName: String,
    var overrideService: IManualJobOverrideService
) : JobParametersIncrementer {

    override fun getNext(previousParameters: JobParameters?): JobParameters? {
        overrideService.getOverrideJobIfExists(jobName)?.let { return@getNext it }

        if (previousParameters?.getDate(TILL_PROP) != null) {
            if (jobRepository.getLastJobExecution(jobName, previousParameters)?.status != BatchStatus.COMPLETED) {
                // restart with the same parameters
                return previousParameters
            }
        }
        val params = previousParameters ?: JobParameters()

        val jobParametersBuilder = JobParametersBuilder()

        val startFrom = params.getDate(TILL_PROP)?.toInstant() ?: props.startAt
        jobParametersBuilder.addDate(
            FROM_PROP, Date.from(
                startFrom
            )
        )
        jobParametersBuilder.addDate(
            TILL_PROP, Date.from(calculateTillDate(startFrom))
        )

        // by this we avoid checks for the same parameters in SimpleJobRepository and other places that can hit us
        // in future
        jobParametersBuilder.addDate(STARTED_AT, Date())

        return jobParametersBuilder.toJobParameters()
    }

    private fun calculateTillDate(startFrom: Instant): Instant {
        val maxTill = startFrom.plus(props.checkoutSpan)
        val now = Instant.now()
        return if (maxTill.isBefore(now))
            maxTill
        else now
    }
}
