package ru.yandex.travel.hotels.extranet.extract.support

import lombok.extern.slf4j.Slf4j
import org.slf4j.LoggerFactory
import org.springframework.batch.core.BatchStatus
import org.springframework.batch.core.JobExecution
import org.springframework.batch.core.JobExecutionListener
import ru.yandex.travel.hotels.extranet.extract.grpc.MANUAL_OVERRIDE

@Slf4j
class ErrorReportingListener : JobExecutionListener {
    private val log = LoggerFactory.getLogger(javaClass)

    override fun beforeJob(jobExecution: JobExecution) {
        if (jobExecution.jobParameters.getLong(MANUAL_OVERRIDE) != null) {
            log.info("\n\n==========  STARTING MANUAL JOB ${jobExecution.jobParameters.getLong(MANUAL_OVERRIDE)} ====================\n\n")
        }
    }

    override fun afterJob(jobExecution: JobExecution) {
        if (jobExecution.status == BatchStatus.FAILED) {
            // TODO report to solomon
            log.error("Error executing job {}", jobExecution)
        }
        if (jobExecution.jobParameters.getLong(MANUAL_OVERRIDE) != null) {
            log.info("\n==========  ENDING MANUAL JOB ${jobExecution.jobParameters.getLong(MANUAL_OVERRIDE)} ====================\n")
        }
    }
}
