package ru.yandex.travel.hotels.extranet.extract.support

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.validation.annotation.Validated
import java.time.Duration
import java.time.temporal.ChronoUnit

@ConstructorBinding
@ConfigurationProperties(value = "high-availability")
@Validated
data class HaConfigurationProperties(
    var enabled: Boolean = false,

    var stopDuration: Duration = Duration.of(5, ChronoUnit.SECONDS),

    var promoteDuration: Duration = Duration.of(10, ChronoUnit.SECONDS),

    var retryAcquireMasterLockDuration: Duration = Duration.of(5, ChronoUnit.SECONDS),

    var masterLockPingDuration: Duration = Duration.of(5, ChronoUnit.SECONDS),

    var masterLockInitialPingDelayDuration: Duration = Duration.of(100, ChronoUnit.MILLIS),

    var masterPingQueryTimeoutSeconds: Int = 1,
)
